using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using Microsoft.Win32;

namespace BeWise.SharpBuilderTools.Gui
{
	public class FrmOptions : System.Windows.Forms.Form
	{

        // *************************************************************************
        //                       Constructor / Destructor
        // *************************************************************************
        
        public FrmOptions()
		{
			InitializeComponent();
		}


		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		// *************************************************************************
		//                              Private
		// *************************************************************************

		private System.Windows.Forms.Button btCancel;
        private System.Windows.Forms.Button btOk;
        private System.Windows.Forms.GroupBox groupBox1;
        private System.Windows.Forms.Label label1;
        private System.Windows.Forms.TextBox txtNAntPath;
		private System.ComponentModel.Container components = null;
		private System.Windows.Forms.TextBox txtAntPath;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.GroupBox groupBox2;
		private System.Windows.Forms.TextBox txtProjectStartupDirectory;
		private System.Windows.Forms.Label label5;
		private System.Windows.Forms.GroupBox groupBox3;
		private System.Windows.Forms.TextBox txtAStylePath;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.RadioButton rbNAnt;
		private System.Windows.Forms.RadioButton rbAnt;
		private System.Windows.Forms.Label label4;
		private System.Windows.Forms.TextBox txtAStyleCommandLine;
		private bool fProjectStartupChanged = false;
		private System.Windows.Forms.TabControl tabControl;
		private System.Windows.Forms.TabPage tpAnt;
		private System.Windows.Forms.TabPage tpGeneral;
		private System.Windows.Forms.TabPage tpAStyle;
		private System.Windows.Forms.Button btAStylePath;
		private System.Windows.Forms.Button btNAntPath;
		private System.Windows.Forms.Button btAntPath;
		private System.Windows.Forms.Button btDefaultDirPath;
		private System.Windows.Forms.RadioButton rbDefault;
		private System.Windows.Forms.RadioButton rbCommandLine;
		private System.Windows.Forms.RadioButton rbCustom;
		private System.Windows.Forms.RadioButton rbAnsi;
		private System.Windows.Forms.RadioButton rbKernighanRitchie;
		private System.Windows.Forms.GroupBox gbAStylePredifined;
		private System.Windows.Forms.TextBox txtPredifinedStyle;
		private System.Windows.Forms.GroupBox gbAStyleCommandLine;
		private System.Windows.Forms.RadioButton rbLinux;
		private System.Windows.Forms.RadioButton rbGNU;
		private System.Windows.Forms.RadioButton rbJava;

		private void btOk_Click(object sender, System.EventArgs e) {
			Main.Configuration.NAntPath = txtNAntPath.Text;
			Main.Configuration.AntPath = txtAntPath.Text;
			Main.Configuration.AStylePath = txtAStylePath.Text;
			Main.Configuration.AStyleParams = GetAStyleParams();

			Main.Configuration.UseAnt = rbAnt.Checked;

			// Save Project Startup Dir
			if (txtProjectStartupDirectory.Text != "") {
				RegistryKey _Key = Registry.CurrentUser.OpenSubKey(@"Software\Borland\BDS\1.0\Globals", true);

				if ( _Key == null ) {
					_Key = Registry.CurrentUser.CreateSubKey(@"Software\Borland\BDS\1.0\Globals");
				}

				_Key.SetValue(@"DefaultProjectsDirectory", txtProjectStartupDirectory.Text);
			}

			if (fProjectStartupChanged) {
				MessageBox.Show("The new Default projects directory will be available next time you start the application", Consts.MESSAGE_BOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Information);
			}

			Main.Configuration.AStyleConfiguration.Style = GetCurrentAStyleStyle();
			Main.Configuration.AStyleConfiguration.CommandLineParams = txtAStyleCommandLine.Text;
		}

		private void FrmOptions_Load(object sender, System.EventArgs e) {
			txtNAntPath.Text = Main.Configuration.NAntPath;
			txtAntPath.Text = Main.Configuration.AntPath;
			rbAnt.Checked = Main.Configuration.UseAnt;

			RegistryKey _Key = Registry.CurrentUser.OpenSubKey(@"Software\Borland\BDS\1.0\Globals");

			if ( _Key != null && Array.IndexOf(_Key.GetValueNames(), @"DefaultProjectsDirectory") > -1) {

				txtProjectStartupDirectory.Text = _Key.GetValue(@"DefaultProjectsDirectory").ToString();
			}

			txtAStylePath.Text = Main.Configuration.AStylePath;
			txtAStyleCommandLine.Text = Main.Configuration.AStyleConfiguration.CommandLineParams;

			switch (Main.Configuration.AStyleConfiguration.Style) {
				case AStyleStyle.Ansi:
					rbAnsi.Checked = true;
					break;
				case AStyleStyle.KernighanRitchie:
					rbKernighanRitchie.Checked = true;
					break;
				case AStyleStyle.Linux:
					rbLinux.Checked = true;
					break;
				case AStyleStyle.GNU:
					rbGNU.Checked = true;
					break;
				case AStyleStyle.Java:
					rbJava.Checked = true;
					break;
				case AStyleStyle.CommandLine:
					rbCommandLine.Checked = true;
					break;
				default:
					rbDefault.Checked = true;
					break;
			}

			rbAStyle_CheckedChanged(null, null);
		}

		private void InitializeComponent()
		{
			this.btCancel = new System.Windows.Forms.Button();
			this.btOk = new System.Windows.Forms.Button();
			this.tabControl = new System.Windows.Forms.TabControl();
			this.tpGeneral = new System.Windows.Forms.TabPage();
			this.groupBox2 = new System.Windows.Forms.GroupBox();
			this.txtProjectStartupDirectory = new System.Windows.Forms.TextBox();
			this.label5 = new System.Windows.Forms.Label();
			this.btDefaultDirPath = new System.Windows.Forms.Button();
			this.tpAnt = new System.Windows.Forms.TabPage();
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.btNAntPath = new System.Windows.Forms.Button();
			this.rbAnt = new System.Windows.Forms.RadioButton();
			this.rbNAnt = new System.Windows.Forms.RadioButton();
			this.txtAntPath = new System.Windows.Forms.TextBox();
			this.label2 = new System.Windows.Forms.Label();
			this.txtNAntPath = new System.Windows.Forms.TextBox();
			this.label1 = new System.Windows.Forms.Label();
			this.btAntPath = new System.Windows.Forms.Button();
			this.tpAStyle = new System.Windows.Forms.TabPage();
			this.groupBox3 = new System.Windows.Forms.GroupBox();
			this.rbJava = new System.Windows.Forms.RadioButton();
			this.rbGNU = new System.Windows.Forms.RadioButton();
			this.rbLinux = new System.Windows.Forms.RadioButton();
			this.rbKernighanRitchie = new System.Windows.Forms.RadioButton();
			this.rbAnsi = new System.Windows.Forms.RadioButton();
			this.rbCustom = new System.Windows.Forms.RadioButton();
			this.rbCommandLine = new System.Windows.Forms.RadioButton();
			this.rbDefault = new System.Windows.Forms.RadioButton();
			this.txtAStylePath = new System.Windows.Forms.TextBox();
			this.label3 = new System.Windows.Forms.Label();
			this.btAStylePath = new System.Windows.Forms.Button();
			this.gbAStyleCommandLine = new System.Windows.Forms.GroupBox();
			this.txtAStyleCommandLine = new System.Windows.Forms.TextBox();
			this.label4 = new System.Windows.Forms.Label();
			this.gbAStylePredifined = new System.Windows.Forms.GroupBox();
			this.txtPredifinedStyle = new System.Windows.Forms.TextBox();
			this.tabControl.SuspendLayout();
			this.tpGeneral.SuspendLayout();
			this.groupBox2.SuspendLayout();
			this.tpAnt.SuspendLayout();
			this.groupBox1.SuspendLayout();
			this.tpAStyle.SuspendLayout();
			this.groupBox3.SuspendLayout();
			this.gbAStyleCommandLine.SuspendLayout();
			this.gbAStylePredifined.SuspendLayout();
			this.SuspendLayout();
			// 
			// btCancel
			// 
			this.btCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btCancel.Location = new System.Drawing.Point(506, 418);
			this.btCancel.Name = "btCancel";
			this.btCancel.Size = new System.Drawing.Size(80, 24);
			this.btCancel.TabIndex = 2;
			this.btCancel.Text = "Cancel";
			// 
			// btOk
			// 
			this.btOk.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btOk.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btOk.Location = new System.Drawing.Point(418, 418);
			this.btOk.Name = "btOk";
			this.btOk.Size = new System.Drawing.Size(80, 24);
			this.btOk.TabIndex = 1;
			this.btOk.Text = "Ok";
			this.btOk.Click += new System.EventHandler(this.btOk_Click);
			// 
			// tabControl
			// 
			this.tabControl.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
						| System.Windows.Forms.AnchorStyles.Left) 
						| System.Windows.Forms.AnchorStyles.Right)));
			this.tabControl.Controls.Add(this.tpGeneral);
			this.tabControl.Controls.Add(this.tpAnt);
			this.tabControl.Controls.Add(this.tpAStyle);
			this.tabControl.Location = new System.Drawing.Point(8, 8);
			this.tabControl.Name = "tabControl";
			this.tabControl.SelectedIndex = 0;
			this.tabControl.Size = new System.Drawing.Size(584, 400);
			this.tabControl.TabIndex = 0;
			// 
			// tpGeneral
			// 
			this.tpGeneral.Controls.Add(this.groupBox2);
			this.tpGeneral.Location = new System.Drawing.Point(4, 22);
			this.tpGeneral.Name = "tpGeneral";
			this.tpGeneral.Size = new System.Drawing.Size(576, 374);
			this.tpGeneral.TabIndex = 1;
			this.tpGeneral.Text = "General";
			// 
			// groupBox2
			// 
			this.groupBox2.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
						| System.Windows.Forms.AnchorStyles.Left) 
						| System.Windows.Forms.AnchorStyles.Right)));
			this.groupBox2.Controls.Add(this.txtProjectStartupDirectory);
			this.groupBox2.Controls.Add(this.label5);
			this.groupBox2.Controls.Add(this.btDefaultDirPath);
			this.groupBox2.Location = new System.Drawing.Point(8, 8);
			this.groupBox2.Name = "groupBox2";
			this.groupBox2.Size = new System.Drawing.Size(560, 360);
			this.groupBox2.TabIndex = 0;
			this.groupBox2.TabStop = false;
			// 
			// txtProjectStartupDirectory
			// 
			this.txtProjectStartupDirectory.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
						| System.Windows.Forms.AnchorStyles.Right)));
			this.txtProjectStartupDirectory.Location = new System.Drawing.Point(120, 20);
			this.txtProjectStartupDirectory.Name = "txtProjectStartupDirectory";
			this.txtProjectStartupDirectory.Size = new System.Drawing.Size(397, 20);
			this.txtProjectStartupDirectory.TabIndex = 0;
			this.txtProjectStartupDirectory.Text = "";
			// 
			// label5
			// 
			this.label5.Location = new System.Drawing.Point(8, 16);
			this.label5.Name = "label5";
			this.label5.Size = new System.Drawing.Size(128, 32);
			this.label5.TabIndex = 6;
			this.label5.Text = "Default projects directory:";
			// 
			// btDefaultDirPath
			// 
			this.btDefaultDirPath.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btDefaultDirPath.Location = new System.Drawing.Point(525, 23);
			this.btDefaultDirPath.Name = "btDefaultDirPath";
			this.btDefaultDirPath.Size = new System.Drawing.Size(24, 16);
			this.btDefaultDirPath.TabIndex = 1;
			this.btDefaultDirPath.Text = "...";
			this.btDefaultDirPath.Click += new System.EventHandler(this.btPath_Click);
			// 
			// tpAnt
			// 
			this.tpAnt.Controls.Add(this.groupBox1);
			this.tpAnt.Location = new System.Drawing.Point(4, 22);
			this.tpAnt.Name = "tpAnt";
			this.tpAnt.Size = new System.Drawing.Size(576, 374);
			this.tpAnt.TabIndex = 0;
			this.tpAnt.Text = "Ant / NAnt";
			// 
			// groupBox1
			// 
			this.groupBox1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
						| System.Windows.Forms.AnchorStyles.Left) 
						| System.Windows.Forms.AnchorStyles.Right)));
			this.groupBox1.Controls.Add(this.btNAntPath);
			this.groupBox1.Controls.Add(this.rbAnt);
			this.groupBox1.Controls.Add(this.rbNAnt);
			this.groupBox1.Controls.Add(this.txtAntPath);
			this.groupBox1.Controls.Add(this.label2);
			this.groupBox1.Controls.Add(this.txtNAntPath);
			this.groupBox1.Controls.Add(this.label1);
			this.groupBox1.Controls.Add(this.btAntPath);
			this.groupBox1.Location = new System.Drawing.Point(8, 8);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(560, 360);
			this.groupBox1.TabIndex = 3;
			this.groupBox1.TabStop = false;
			// 
			// btNAntPath
			// 
			this.btNAntPath.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btNAntPath.Location = new System.Drawing.Point(525, 50);
			this.btNAntPath.Name = "btNAntPath";
			this.btNAntPath.Size = new System.Drawing.Size(24, 16);
			this.btNAntPath.TabIndex = 6;
			this.btNAntPath.Text = "...";
			this.btNAntPath.Click += new System.EventHandler(this.btPath_Click);
			// 
			// rbAnt
			// 
			this.rbAnt.Location = new System.Drawing.Point(128, 16);
			this.rbAnt.Name = "rbAnt";
			this.rbAnt.Size = new System.Drawing.Size(184, 24);
			this.rbAnt.TabIndex = 5;
			this.rbAnt.Text = "Use Ant";
			// 
			// rbNAnt
			// 
			this.rbNAnt.Checked = true;
			this.rbNAnt.Location = new System.Drawing.Point(8, 16);
			this.rbNAnt.Name = "rbNAnt";
			this.rbNAnt.Size = new System.Drawing.Size(96, 24);
			this.rbNAnt.TabIndex = 4;
			this.rbNAnt.TabStop = true;
			this.rbNAnt.Text = "Use NAnt";
			// 
			// txtAntPath
			// 
			this.txtAntPath.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
						| System.Windows.Forms.AnchorStyles.Right)));
			this.txtAntPath.Location = new System.Drawing.Point(120, 80);
			this.txtAntPath.Name = "txtAntPath";
			this.txtAntPath.Size = new System.Drawing.Size(397, 20);
			this.txtAntPath.TabIndex = 3;
			this.txtAntPath.Text = "";
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(8, 80);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(64, 24);
			this.label2.TabIndex = 2;
			this.label2.Text = "Ant Path:";
			// 
			// txtNAntPath
			// 
			this.txtNAntPath.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
						| System.Windows.Forms.AnchorStyles.Right)));
			this.txtNAntPath.Location = new System.Drawing.Point(120, 48);
			this.txtNAntPath.Name = "txtNAntPath";
			this.txtNAntPath.Size = new System.Drawing.Size(397, 20);
			this.txtNAntPath.TabIndex = 1;
			this.txtNAntPath.Text = "";
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(8, 48);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(64, 24);
			this.label1.TabIndex = 0;
			this.label1.Text = "NAnt Path:";
			// 
			// btAntPath
			// 
			this.btAntPath.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btAntPath.Location = new System.Drawing.Point(525, 82);
			this.btAntPath.Name = "btAntPath";
			this.btAntPath.Size = new System.Drawing.Size(24, 16);
			this.btAntPath.TabIndex = 6;
			this.btAntPath.Text = "...";
			this.btAntPath.Click += new System.EventHandler(this.btPath_Click);
			// 
			// tpAStyle
			// 
			this.tpAStyle.Controls.Add(this.groupBox3);
			this.tpAStyle.Location = new System.Drawing.Point(4, 22);
			this.tpAStyle.Name = "tpAStyle";
			this.tpAStyle.Size = new System.Drawing.Size(576, 374);
			this.tpAStyle.TabIndex = 2;
			this.tpAStyle.Text = "AStyle";
			// 
			// groupBox3
			// 
			this.groupBox3.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
						| System.Windows.Forms.AnchorStyles.Left) 
						| System.Windows.Forms.AnchorStyles.Right)));
			this.groupBox3.Controls.Add(this.rbJava);
			this.groupBox3.Controls.Add(this.rbGNU);
			this.groupBox3.Controls.Add(this.rbLinux);
			this.groupBox3.Controls.Add(this.rbKernighanRitchie);
			this.groupBox3.Controls.Add(this.rbAnsi);
			this.groupBox3.Controls.Add(this.rbCustom);
			this.groupBox3.Controls.Add(this.rbCommandLine);
			this.groupBox3.Controls.Add(this.rbDefault);
			this.groupBox3.Controls.Add(this.txtAStylePath);
			this.groupBox3.Controls.Add(this.label3);
			this.groupBox3.Controls.Add(this.btAStylePath);
			this.groupBox3.Controls.Add(this.gbAStyleCommandLine);
			this.groupBox3.Controls.Add(this.gbAStylePredifined);
			this.groupBox3.Location = new System.Drawing.Point(8, 8);
			this.groupBox3.Name = "groupBox3";
			this.groupBox3.Size = new System.Drawing.Size(568, 360);
			this.groupBox3.TabIndex = 5;
			this.groupBox3.TabStop = false;
			// 
			// rbJava
			// 
			this.rbJava.Location = new System.Drawing.Point(440, 80);
			this.rbJava.Name = "rbJava";
			this.rbJava.TabIndex = 20;
			this.rbJava.Text = "Java";
			this.rbJava.CheckedChanged += new System.EventHandler(this.rbAStyle_CheckedChanged);
			// 
			// rbGNU
			// 
			this.rbGNU.Location = new System.Drawing.Point(336, 80);
			this.rbGNU.Name = "rbGNU";
			this.rbGNU.TabIndex = 19;
			this.rbGNU.Text = "GNU";
			this.rbGNU.CheckedChanged += new System.EventHandler(this.rbAStyle_CheckedChanged);
			// 
			// rbLinux
			// 
			this.rbLinux.Location = new System.Drawing.Point(232, 80);
			this.rbLinux.Name = "rbLinux";
			this.rbLinux.TabIndex = 18;
			this.rbLinux.Text = "Linux";
			this.rbLinux.CheckedChanged += new System.EventHandler(this.rbAStyle_CheckedChanged);
			// 
			// rbKernighanRitchie
			// 
			this.rbKernighanRitchie.Location = new System.Drawing.Point(104, 80);
			this.rbKernighanRitchie.Name = "rbKernighanRitchie";
			this.rbKernighanRitchie.Size = new System.Drawing.Size(112, 24);
			this.rbKernighanRitchie.TabIndex = 15;
			this.rbKernighanRitchie.Text = "Kernighan Ritchie";
			this.rbKernighanRitchie.CheckedChanged += new System.EventHandler(this.rbAStyle_CheckedChanged);
			// 
			// rbAnsi
			// 
			this.rbAnsi.Location = new System.Drawing.Point(16, 80);
			this.rbAnsi.Name = "rbAnsi";
			this.rbAnsi.TabIndex = 14;
			this.rbAnsi.Text = "Ansi";
			this.rbAnsi.CheckedChanged += new System.EventHandler(this.rbAStyle_CheckedChanged);
			// 
			// rbCustom
			// 
			this.rbCustom.Location = new System.Drawing.Point(232, 48);
			this.rbCustom.Name = "rbCustom";
			this.rbCustom.TabIndex = 13;
			this.rbCustom.Text = "Custom";
			this.rbCustom.Visible = false;
			this.rbCustom.CheckedChanged += new System.EventHandler(this.rbAStyle_CheckedChanged);
			// 
			// rbCommandLine
			// 
			this.rbCommandLine.Location = new System.Drawing.Point(104, 48);
			this.rbCommandLine.Name = "rbCommandLine";
			this.rbCommandLine.TabIndex = 12;
			this.rbCommandLine.Text = "Command Line";
			this.rbCommandLine.CheckedChanged += new System.EventHandler(this.rbAStyle_CheckedChanged);
			// 
			// rbDefault
			// 
			this.rbDefault.Checked = true;
			this.rbDefault.Location = new System.Drawing.Point(16, 48);
			this.rbDefault.Name = "rbDefault";
			this.rbDefault.Size = new System.Drawing.Size(80, 24);
			this.rbDefault.TabIndex = 11;
			this.rbDefault.TabStop = true;
			this.rbDefault.Text = "Default";
			this.rbDefault.CheckedChanged += new System.EventHandler(this.rbAStyle_CheckedChanged);
			// 
			// txtAStylePath
			// 
			this.txtAStylePath.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
						| System.Windows.Forms.AnchorStyles.Right)));
			this.txtAStylePath.Location = new System.Drawing.Point(120, 19);
			this.txtAStylePath.Name = "txtAStylePath";
			this.txtAStylePath.Size = new System.Drawing.Size(404, 20);
			this.txtAStylePath.TabIndex = 7;
			this.txtAStylePath.Text = "";
			// 
			// label3
			// 
			this.label3.Location = new System.Drawing.Point(8, 23);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(80, 17);
			this.label3.TabIndex = 6;
			this.label3.Text = "AStyle Path:";
			// 
			// btAStylePath
			// 
			this.btAStylePath.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btAStylePath.Location = new System.Drawing.Point(532, 22);
			this.btAStylePath.Name = "btAStylePath";
			this.btAStylePath.Size = new System.Drawing.Size(24, 16);
			this.btAStylePath.TabIndex = 5;
			this.btAStylePath.Text = "...";
			this.btAStylePath.Click += new System.EventHandler(this.btPath_Click);
			// 
			// gbAStyleCommandLine
			// 
			this.gbAStyleCommandLine.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
						| System.Windows.Forms.AnchorStyles.Left) 
						| System.Windows.Forms.AnchorStyles.Right)));
			this.gbAStyleCommandLine.Controls.Add(this.txtAStyleCommandLine);
			this.gbAStyleCommandLine.Controls.Add(this.label4);
			this.gbAStyleCommandLine.Location = new System.Drawing.Point(14, 112);
			this.gbAStyleCommandLine.Name = "gbAStyleCommandLine";
			this.gbAStyleCommandLine.Size = new System.Drawing.Size(544, 240);
			this.gbAStyleCommandLine.TabIndex = 21;
			this.gbAStyleCommandLine.TabStop = false;
			this.gbAStyleCommandLine.Text = "Command Line";
			// 
			// txtAStyleCommandLine
			// 
			this.txtAStyleCommandLine.Location = new System.Drawing.Point(152, 24);
			this.txtAStyleCommandLine.Name = "txtAStyleCommandLine";
			this.txtAStyleCommandLine.Size = new System.Drawing.Size(232, 20);
			this.txtAStyleCommandLine.TabIndex = 11;
			this.txtAStyleCommandLine.Text = "";
			// 
			// label4
			// 
			this.label4.Location = new System.Drawing.Point(16, 28);
			this.label4.Name = "label4";
			this.label4.Size = new System.Drawing.Size(136, 36);
			this.label4.TabIndex = 10;
			this.label4.Text = "AStyle Command Line:";
			// 
			// gbAStylePredifined
			// 
			this.gbAStylePredifined.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
						| System.Windows.Forms.AnchorStyles.Left) 
						| System.Windows.Forms.AnchorStyles.Right)));
			this.gbAStylePredifined.Controls.Add(this.txtPredifinedStyle);
			this.gbAStylePredifined.Location = new System.Drawing.Point(16, 112);
			this.gbAStylePredifined.Name = "gbAStylePredifined";
			this.gbAStylePredifined.Size = new System.Drawing.Size(544, 240);
			this.gbAStylePredifined.TabIndex = 16;
			this.gbAStylePredifined.TabStop = false;
			this.gbAStylePredifined.Text = "Predifined Style";
			// 
			// txtPredifinedStyle
			// 
			this.txtPredifinedStyle.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
						| System.Windows.Forms.AnchorStyles.Left) 
						| System.Windows.Forms.AnchorStyles.Right)));
			this.txtPredifinedStyle.Location = new System.Drawing.Point(11, 14);
			this.txtPredifinedStyle.Multiline = true;
			this.txtPredifinedStyle.Name = "txtPredifinedStyle";
			this.txtPredifinedStyle.ReadOnly = true;
			this.txtPredifinedStyle.Size = new System.Drawing.Size(522, 218);
			this.txtPredifinedStyle.TabIndex = 12;
			this.txtPredifinedStyle.Text = "";
			// 
			// FrmOptions
			// 
			this.AcceptButton = this.btOk;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btCancel;
			this.ClientSize = new System.Drawing.Size(602, 448);
			this.Controls.Add(this.btOk);
			this.Controls.Add(this.btCancel);
			this.Controls.Add(this.tabControl);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.MinimumSize = new System.Drawing.Size(512, 304);
			this.Name = "FrmOptions";
			this.ShowInTaskbar = false;
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			this.Text = "Sharp Builder Tools - Options";
			this.Load += new System.EventHandler(this.FrmOptions_Load);
			this.tabControl.ResumeLayout(false);
			this.tpGeneral.ResumeLayout(false);
			this.groupBox2.ResumeLayout(false);
			this.tpAnt.ResumeLayout(false);
			this.groupBox1.ResumeLayout(false);
			this.tpAStyle.ResumeLayout(false);
			this.groupBox3.ResumeLayout(false);
			this.gbAStyleCommandLine.ResumeLayout(false);
			this.gbAStylePredifined.ResumeLayout(false);
			this.ResumeLayout(false);
		}

		private void txtProjectStartupDirectory_TextChanged(object sender, System.EventArgs e)
		{
			fProjectStartupChanged = true;
		}

		private void btPath_Click(object sender, System.EventArgs e)
		{
			TextBox _Txt = GetPathTextBoxFromButton((Button) sender);

			if (_Txt != null) {
				FolderBrowserDialog _Dlg = new FolderBrowserDialog();

				_Dlg.SelectedPath = _Txt.Text;
				
				if (_Dlg.ShowDialog() == DialogResult.OK) {
					_Txt.Text = _Dlg.SelectedPath;
				}
			} 
		}

		private TextBox GetPathTextBoxFromButton(Button aButton) {
			if (aButton == btAntPath) {
				return txtAntPath;
			}
			else if (aButton == btNAntPath) {
				return txtNAntPath;
			}
			else if (aButton == btDefaultDirPath) {
				return txtProjectStartupDirectory;
			}
			else if (aButton == btAStylePath) {
            	return txtAStylePath;
			}
			else {
				return null;
			}
		}
		
		private void rbAStyle_CheckedChanged(object sender, System.EventArgs e) {
			AStyleStyle _AStyleStyle = GetCurrentAStyleStyle();

			switch (_AStyleStyle) {
				case AStyleStyle.Ansi:
				case AStyleStyle.KernighanRitchie:
				case AStyleStyle.Linux:
				case AStyleStyle.GNU:
				case AStyleStyle.Java:
					gbAStyleCommandLine.Visible = false;
					gbAStylePredifined.Visible = true;
                    txtPredifinedStyle.Lines = GetPredifinedStyleExample(_AStyleStyle);
					break;
				case AStyleStyle.CommandLine:
					gbAStyleCommandLine.Visible = true;
					gbAStylePredifined.Visible = false;
					break;
				default:
					gbAStyleCommandLine.Visible = false;
					gbAStylePredifined.Visible = false;
					break;
			}
		}

		private AStyleStyle GetCurrentAStyleStyle() {
			if (rbLinux.Checked) {
				return AStyleStyle.Linux;
			}
			else if (rbGNU.Checked) {
				return AStyleStyle.GNU;
			}
			else if (rbJava.Checked) {
				return AStyleStyle.Java;
			}
			else if (rbKernighanRitchie.Checked) {
				return AStyleStyle.KernighanRitchie;
			}
			else if (rbCommandLine.Checked) {
				return AStyleStyle.CommandLine;
			}
			else if (rbCustom.Checked) {
				return AStyleStyle.Custom;
			}
			else if (rbAnsi.Checked) {
				return AStyleStyle.Ansi;
			}
			else {
				return AStyleStyle.Default;
			}
		}

		private string GetAStyleParams() {
			if (rbLinux.Checked) {
				return "--style=ansi";
			}
			else if (rbGNU.Checked) {
				return "--style=gnu";
			}
			else if (rbJava.Checked) {
				return "--style=java";
			}
			else if (rbKernighanRitchie.Checked) {
				return "--style=kr";
			}
			else if (rbCommandLine.Checked) {
				return txtAStyleCommandLine.Text;
			}
			else if (rbAnsi.Checked) {
				return "--style=ansi";
			}
			else {
				return Consts.DEFAULT_ASTYLE_PARAMS;
			}
		}

		private string[] GetPredifinedStyleExample(AStyleStyle aAStyleStyle) {
			string[] _Lines;

			switch (aAStyleStyle) {
				case AStyleStyle.Ansi:
					_Lines = new string[] {
							"--style=ansi",
							"ANSI style formatting/indenting.",
							"",
							"namespace foospace",
							"{",
							"    int Foo()",
							"    {",
							"        if (isBar)",
							"        {",
							"            bar();",
							"            return 1;",
							"        }",
							"        else",
							"            return 0;",
							"    }",
							"}"};

					break;

				case AStyleStyle.KernighanRitchie:
					_Lines = new string[] {
							"--style=kr",
							"Kernighan&Ritchie style formatting/indenting.",
							"",
							"namespace foospace {",
							"	int Foo() {",
							"		if (isBar) {",
							"			bar();",
							"			return 1;",
							"		} else",
							"			return 0;",
							"	}",
							"}"};

					break;

				case AStyleStyle.Linux:
					_Lines = new string[] {
							"--style=linux",
							"Linux style formatting/indenting (brackets are broken apart from class/function declarations, but connected to command lines, and indents are set to 8 spaces).",
							"",
							"namespace foospace",
							"{",
							"		int Foo()",
							"		{",
							"				if (isBar) {",
							"						bar();",
							"						return 1;",
							"				} else",
							"						return 0;",
							"		}",
							"}"};

					break;

				case AStyleStyle.GNU:
					_Lines = new string[] {
							"--style=gnu",
							"GNU style formatting/indenting.",
							"",
							"namespace foospace",
							"  {",
							"	int Foo()",
							"	  {",
							"		if (isBar)",
							"		  {",
							"			bar();",
							"			return 1;",
							"		  }",
							"		else",
							"		  return 0;",
							"	  }",
							"}"};
					break;

				case AStyleStyle.Java:
					_Lines = new string[] {
							"--style=java",
							"Java style formatting/indenting.",
							"",
							"class foospace {",
							"    int Foo() {",
							"        if (isBar) {",
							"            bar();",
							"            return 1;",
							"        } else",
							"            return 0;",
							"    }",
							"}"};
					break;

				default:
					_Lines = new string[] {};
					break;
			}

			return _Lines;
		}
	}
}
